/* This was originally the typewriter homework assigned as
Homework #1 for CS 160, Fall 97. Due Thursday October1.

Then R.R. chagned 10/2/97,  to use caret.
10/9/97, made caret be textcolor */

#define COLORED_CARET
/* If you have a problem in porting the caret code to MFC, then comment
out the COLORED_CARET switch and port the simpler code */
#define CARET_WIDTH 2

#include "types.h" //includes <windows.h>
#include "bitmap1.hpp"
#include <ctype.h> //For isalnum
#include "resource.h"

LRESULT CALLBACK WndProc( HWND, UINT, WPARAM, LPARAM);
void GetCharSpacing(HDC hdc);
void CreateLineCaret(HWND hwnd, int cx, int cy);

int cxChar, cyChar;
HBITMAP hcaretbitmap = NULL;

COLORREF backgroundcolor = RGB(255, 255, 200);
COLORREF textcolor = RGB(0, 0, 0);
POINT curpos = {10, 20};

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
	PSTR lpszCmdParam, int nCmdShow)
{
	static char szAppName[] = "Typewriter";
	HWND masterhwnd;
	MSG msg;
	WNDCLASSEX wndclass;

	if (!hPrevInstance)
	{
		wndclass.cbSize = sizeof(wndclass);
		wndclass.style = CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc = WndProc;
		wndclass.cbClsExtra = 0;
		wndclass.cbWndExtra = 0;
		wndclass.hInstance = hInstance;
		wndclass.hIcon = LoadIcon( hInstance, MAKEINTRESOURCE(IDI_ICON1) );
		wndclass.hCursor = LoadCursor( NULL, IDC_CROSS );
		wndclass.hbrBackground = NULL;
	// I used to have (HBRUSH)CreateSolidBrush(backgroundcolor) here, but in
	// fact NULL is OK, because I never actually erase the background with
	// the brush, I always just BitBlt to it out of wbm.  See WNDCLASSEX Help.
		wndclass.lpszMenuName = NULL;
		wndclass.lpszClassName = szAppName;
		wndclass.hIconSm = LoadIcon( NULL, IDI_QUESTION );
		RegisterClassEx (&wndclass);
	}

	masterhwnd = CreateWindow(szAppName,		// window class name
		"Typewriter2. Type goes at cursor.  F1 clears.  F2 Selects font. 10/6/97 Rudy Rucker",	// window caption
			WS_OVERLAPPEDWINDOW,		// window style
			CW_USEDEFAULT,				// initial x position
			CW_USEDEFAULT,				// initial y position
			CW_USEDEFAULT,				// initial x size
			CW_USEDEFAULT,				// initial y size
			NULL,					// parent window handle
			NULL,					// window menu handle
			hInstance,				// program instance handle
			NULL);					// creation parameters

	ShowWindow(masterhwnd, nCmdShow);
	UpdateWindow(masterhwnd);

	while ( GetMessage( &msg, NULL, 0, 0 ) )
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return msg.wParam;
}

LRESULT CALLBACK WndProc( HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static WindowBitmap *wbm;
	static LOGFONT logfont;
	static CHOOSEFONT choosefont;
	static HFONT hfont;
	static int leftmargin = 10;
	HDC hdc;
	PAINTSTRUCT ps;
	HFONT holdfont;
	RECT clientrect;
	SIZE lettersize;
	
	switch (message)
	{
		case WM_CREATE:
			wbm = new WindowBitmap(hwnd, backgroundcolor);
			SetBkMode(wbm->hdc(), TRANSPARENT);
			SetTextColor(wbm->hdc(), textcolor);
			/* Initialize the logfont so that you can see a selection in 
			the first call to ChooseFont common dialog. */
			logfont.lfHeight = 20;
			lstrcpy(logfont.lfFaceName, "Courier"); //A common font.
			hfont = CreateFontIndirect(&logfont);
			//We must eventually DeleteObject each hfont we create.
			SelectObject(wbm->hdc(), hfont);
			choosefont.lStructSize = sizeof(CHOOSEFONT);
			choosefont.lpLogFont = &logfont;
			choosefont.hwndOwner = hwnd;
			choosefont.rgbColors = textcolor;
			choosefont.Flags = CF_SCREENFONTS | CF_INITTOLOGFONTSTRUCT | CF_EFFECTS;
	/* Use screenfonts, not printer fonts | show the current font information in
	the ChooseFont dialog box | allow underline and color of text selection */
			GetCharSpacing(wbm->hdc());
			curpos.x = leftmargin;
			curpos.y = cyChar;
			return 0;

		case WM_SETFOCUS:
		//You actually get here before WM_CREATE happens
			CreateLineCaret(hwnd, cxChar, cyChar);
			SetCaretPos(curpos.x, curpos.y);
			ShowCaret(hwnd);
			return 0;

		case WM_KILLFOCUS:
			DestroyCaret();
			return 0;

		case WM_PAINT:
			hdc = BeginPaint(hwnd, &ps);
			wbm->CopyTo(hdc, ps.rcPaint);
			EndPaint(hwnd, &ps);
			return 0;

		case WM_LBUTTONDOWN:
			curpos.x = LOWORD(lParam);
			curpos.y = HIWORD(lParam);
			SetCaretPos(curpos.x, curpos.y);
			return 0;

		case WM_KEYDOWN:
			switch(wParam)
			{
				case VK_F1:
					//Clear out the bitmap
					wbm->Clear();
			//Invalidate client area and send WM_PAINT.   FALSE means you don't need to
			//clear the window because the cleared bitmap will bitblt it.
					InvalidateRect(hwnd, NULL, FALSE);
					break;
				case VK_F2:
					ChooseFont(&choosefont);
					hfont = CreateFontIndirect(&logfont);
					holdfont = SelectObject(wbm->hdc(), hfont);
	/* SelectObject returns the currently selected object of the same type.
	We selected an hfont we made in WM_CREATE, so any hfont we get here will
	be one we made.  So we should DeleteObject it.*/
					DeleteObject(holdfont);
	//The color field is set in ChooseFont, you need to force it into the HDC.
					textcolor = choosefont.rgbColors;
					SetTextColor(wbm->hdc(), textcolor);
					GetCharSpacing(wbm->hdc());
					CreateLineCaret(hwnd, cxChar, cyChar); //Destroys old caret, makes new one.
					SetCaretPos(curpos.x, curpos.y); //Need to reposition.
					ShowCaret(hwnd);
					break;
				case VK_RETURN:
					curpos.x = leftmargin;
					curpos.y += cyChar;
					SetCaretPos(curpos.x, curpos.y);
					ShowCaret(hwnd);
					break;
				case VK_HOME:
					curpos.x = leftmargin;
					curpos.y = cyChar;
					SetCaretPos(curpos.x, curpos.y);
					ShowCaret(hwnd);
					break;
			}
			return 0;

		case WM_CHAR:
		/* We filter out most characters.  For instance tab or Enter would
		make an ugly mark.  Use isalnum, defined in ctype.h, but then you have a
		lot of extras we deal with as special cases.  Note the \ in front of
		the ' and " symbols. */
			if (!( isalnum(wParam)
					|| wParam == ' ' 
					|| wParam == ','
					|| wParam == '.'
					|| wParam == ';'
					|| wParam == ':'
					|| wParam == '!'
					|| wParam == '?'
					|| wParam == '='
					|| wParam == '('
					|| wParam == ')'
					|| wParam == '-'
					|| wParam == '+'
					|| wParam == '*'
					|| wParam == '&'
					|| wParam == '$'
					|| wParam == '\"'
					|| wParam == '\''
				))
				return 0;
			char letter[1];
			letter[0] = wParam;
			GetClientRect(hwnd, &clientrect);
	/* Skip to a new line if you are running off the edge, or if you have a
	typed a space and you are near the edge.*/
			if ((curpos.x >= clientrect.right - cxChar) ||  
				(curpos.x >= clientrect.right - 5*cxChar && wParam == ' '))
			{
				SendMessage(hwnd, WM_KEYDOWN, VK_RETURN, 0);
				if (wParam == ' ') //Don't start the new line with a space.
					return 0;
			}
			//else
			TextOut(wbm->hdc(), curpos.x, curpos.y, letter, 1);
			//	curpos.x += cxChar;
	/* Instead of just adding cxChar to curpos, we can be a little more subtle,
	which is necessary for the more complicate fonts. Use next two lines instead.*/
			GetTextExtentPoint32(wbm->hdc(), letter, 1, &lettersize);
			curpos.x += lettersize.cx;
			SetCaretPos(curpos.x, curpos.y);
			ShowCaret(hwnd);
			InvalidateRect(hwnd, NULL, FALSE);
			return 0;

		case WM_DESTROY:
			delete wbm;
			DeleteObject(hfont); //The last font you created.
			DestroyCaret();
			if (hcaretbitmap)
				DeleteObject(hcaretbitmap);
			PostQuitMessage(0);
			return 0;
	}

	return DefWindowProc(hwnd, message, wParam, lParam);
}

void GetCharSpacing(HDC hdc)
{
	TEXTMETRIC tm;

	GetTextMetrics(hdc, &tm);
	cxChar = tm.tmAveCharWidth;
	cyChar = tm.tmHeight + tm.tmExternalLeading;
}


void CreateLineCaret(HWND hwnd, int cx, int cy)
{ //We want the caret to be a vertical line CARET_WIDTH pixels wide as high as cyChar.
#ifndef COLORED_CARET
// Make the caret a line by making the caret-box narrow!
	DestroyCaret(); //Does nothing if window doesn't own the caret yet.
	CreateCaret(hwnd, NULL, CARET_WIDTH, cyChar);
#else // Create a bitmap.  This is a general solution, allows color.
	HDC hdc, hcaretdc;
	hdc = GetDC(hwnd);
	DestroyCaret(); //Does nothing if window doesn't own the caret yet.
	if (hcaretbitmap)
	{
		DeleteObject(hcaretbitmap);
		hcaretbitmap = NULL;
	}
	//We make a custom bitmap for the second argument of CreateCaret
	hcaretbitmap = CreateCompatibleBitmap(hdc, CARET_WIDTH, cyChar);
	//Now use a temporary HDC to put an image into hcaretbitmap.
	hcaretdc = CreateCompatibleDC(hdc);
	SelectObject(hcaretdc, hcaretbitmap);
	/*The caret is drawn with an XOR write, so to get a textcolor line on
	backgroundcolor, I need the caret to be backgroundcolor ^ textcolor.
	This is because b ^ (b ^ t) = t. */
	HBRUSH hbrush = CreateSolidBrush(backgroundcolor ^ textcolor); 
	SelectObject(hcaretdc, hbrush);
	PatBlt(hcaretdc, 0, 0, CARET_WIDTH, cyChar, PATCOPY); //Fill caret with brush color
	DeleteDC(hcaretdc);
	DeleteObject(hbrush);
	//Now put the hcaretbitmap into the caret.
	CreateCaret(hwnd, hcaretbitmap, CARET_WIDTH, cyChar);
	ReleaseDC(hwnd, hdc);
#endif //COLORED_CARET
}

	
	